from __future__ import generators
import plus
import Arenas
import random
import Hazards
import math


class BoxArena(Arenas.SuperArena):
    "FOR TEAM MATCH GAME TYPE ONLY, Use Players 1 and 3 for two player games. Soccer arena with point scoring goals, for the budding Beckhams amongst you"
    name = "DSL Soccer Arena"
    preview = "DSLSoccerArena/DSLSoccer_preview.bmp"
    game_types = ['DEATHMATCH', 'TEAM MATCH']
    extent = (-12, 16, 12, -16)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/DSLSoccerArena/DSLSoccer.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)
        
        degrad = 0.01745
        self.AddStaticCamera("              StaticCam-1", (0, 22, 0), (90*degrad, 90*degrad), 60*degrad)
        self.AddStaticCamera("              StaticCam-2", (0, 22, 0), (90*degrad, 90*degrad), 70*degrad)
        self.AddStaticCamera("              StaticCam-3", (0, 22, 0), (90*degrad, 90*degrad), 80*degrad)
        self.AddStaticCamera("              StaticCam-4", (0, 22, 0), (90*degrad, 90*degrad), 90*degrad)

        self.AddWatchCamera("               WatchCam-1a", (-20, 15, 0), (16, 20, 70*degrad, 40*degrad))
        self.AddWatchCamera("               WatchCam-1b", (-20, 25, 0), (16, 20, 70*degrad, 40*degrad))
        self.AddWatchCamera("               WatchCam-2a", (20, 15, 0), (16, 20, 70*degrad, 40*degrad))
        self.AddWatchCamera("               WatchCam-2b", (20, 25, 0), (16, 20, 70*degrad, 40*degrad))
        self.AddWatchCamera("               WatchCam-Over", (0, 10, 0), (16, 24, 50*degrad, 40*degrad))
        self.AddWatchCamera("               WatchCam-Over", (0, 20, 0), (16, 24, 50*degrad, 40*degrad))

        
        self.players = ()
        self.ballnumber = 12

        
    def AddShadowReceivers(self):
        self.SetShadowSource(5.897, 19.159, 5.899)
        
        # Main Arena Floor Shadow Triangles
        self.AddShadowTriangle((-10.2877,0.676244,1.83754), (-12.4182,0.676244,12.4283), (-12.4182,0.676244,1.83754))
        self.AddShadowTriangle((-8.17686,0.676244,9.91855), (-8.17686,0.676244,12.4283), (-12.4182,0.676244,12.4283))
        self.AddShadowTriangle((-8.17686,0.676244,9.91855), (-12.4182,0.676244,12.4283), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((2.25999,0.676244,12.4283), (-2.49123,0.676244,12.4283), (-2.49123,0.676244,9.91855))
        self.AddShadowTriangle((2.25999,0.676244,9.91855), (2.25999,0.676244,12.4283), (-2.49123,0.676244,9.91855))
        self.AddShadowTriangle((12.413,0.676244,12.4283), (7.93297,0.676244,12.4283), (7.93297,0.676244,9.91855))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (12.413,0.676244,12.4283), (7.93297,0.676244,9.91855))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (12.413,0.676244,1.91641), (12.413,0.676244,12.4283))
        self.AddShadowTriangle((8.17711,0.676244,-9.92447), (12.413,0.676244,-12.4279), (10.2878,0.676244,-1.93329))
        self.AddShadowTriangle((10.2878,0.676244,-1.93329), (12.413,0.676244,-12.4279), (12.413,0.676244,-1.93329))
        self.AddShadowTriangle((8.17711,0.676244,-9.92447), (8.17711,0.676244,-12.4279), (12.413,0.676244,-12.4279))
        self.AddShadowTriangle((-2.26871,0.676244,-12.4279), (2.49519,0.676244,-12.4279), (2.49519,0.676244,-9.92447))
        self.AddShadowTriangle((-2.26871,0.676244,-9.92447), (-2.26871,0.676244,-12.4279), (2.49519,0.676244,-9.92447))
        self.AddShadowTriangle((-12.4182,0.676244,-12.4279), (-7.93688,0.676244,-12.4279), (-7.93688,0.676244,-9.92447))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (-12.4182,0.676244,-12.4279), (-7.93688,0.676244,-9.92447))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (-12.4182,0.676244,-1.8361), (-12.4182,0.676244,-12.4279))
        self.AddShadowTriangle((-2.49123,0.676244,9.91855), (-8.17686,0.676244,9.91855), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((2.49519,0.676244,-9.92447), (8.17711,0.676244,-9.92447), (10.2878,0.676244,-1.93329))
        self.AddShadowTriangle((10.2878,0.676244,-1.93329), (-10.2877,0.676244,-1.8361), (-2.26871,0.676244,-9.92447))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (7.93297,0.676244,9.91855), (2.25999,0.676244,9.91855))
        self.AddShadowTriangle((2.25999,0.676244,9.91855), (-2.49123,0.676244,9.91855), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (2.25999,0.676244,9.91855), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((10.2878,0.676244,-1.93329), (10.2878,0.676244,1.91641), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (10.2878,0.676244,-1.93329), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((-2.26871,0.676244,-9.92447), (2.49519,0.676244,-9.92447), (10.2878,0.676244,-1.93329))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (-7.93688,0.676244,-9.92447), (-2.26871,0.676244,-9.92447))
        
        # Hazard Shadow Triangles
        self.AddShadowTriangle((-8.0217,0.407085,-12.2193), (-2.21868,0.407085,-12.2193), (-2.21868,0.407085,-9.90302))
        self.AddShadowTriangle((-2.21868,0.407085,-9.90302), (-8.0217,0.407085,-9.90302), (-8.0217,0.407085,-12.2193))
        self.AddShadowTriangle((2.42165,0.407085,-12.2193), (8.22466,0.407085,-12.2193), (8.22466,0.407085,-9.90302))
        self.AddShadowTriangle((8.22466,0.407085,-9.90302), (2.42165,0.407085,-9.90302), (2.42165,0.407085,-12.2193))
        self.AddShadowTriangle((-8.24321,0.407085,9.84521), (-2.4402,0.407085,9.84521), (-2.4402,0.407085,12.1615))
        self.AddShadowTriangle((-2.4402,0.407085,12.1615), (-8.24321,0.407085,12.1615), (-8.24321,0.407085,9.84521))
        self.AddShadowTriangle((2.20013,0.407085,9.84521), (8.00315,0.407085,9.84521), (8.00315,0.407085,12.1615))
        self.AddShadowTriangle((8.00315,0.407085,12.1615), (2.20013,0.407085,12.1615), (2.20013,0.407085,9.84521))
        
    def HazardsOn(self, on):
        self.goal = plus.createSound("Sounds/goal.wav", False, (0, 0, 0))
        self.RegisterZone("redscore", 2)
        self.RegisterZone("bluescore", 1)
        self.AddCollisionLine((-3.5, 3.5), (3.5, 3.5))
        self.AddCollisionLine((3.5, 3.5), (3.5, -3.5))
        self.AddCollisionLine((3.5, -3.5), (-3.5, -3.5))
        self.AddCollisionLine((-3.5, -3.5), (-3.5, 3.5))
        self.AddPOV(0, (10, 0), (0, 2))
        self.AddPOV(1, (0, 10), (1, 3))
        self.AddPOV(2, (-10, 0), (2, 0))
        self.AddPOV(3, (0, -10), (3, 1))
        if on:
            b=11
            while b<33:
                self.SetActive("ball"+str(b), False)
                self.SetSubMaterialSound("ball"+str(b), "metal", 0.0, "Sounds\\hzd_comp_hit.wav")
                b+=1
            self.SetActive("ball11", True)
        return Arenas.SuperArena.HazardsOn(self, on)



    def Activate(self, on):
        if on: self.players = plus.getPlayers()

        Arenas.SuperArena.Activate(self, on)


    def ZoneEvent(self, direction, id, robot, chassis):
        if id==1 and direction==1:
            plus.addPoints(0, 5000)
            plus.playSound(self.goal)
            if self.ballnumber<33:
                self.SetActive("ball"+str(self.ballnumber), True)
                self.ballnumber+=1

        elif id==2 and direction==1:
            plus.addPoints(2, 5000)
            plus.playSound(self.goal)
            if self.ballnumber<33:
                self.SetActive("ball"+str(self.ballnumber), True)
                self.ballnumber+=1

        return True


    def Tick(self):

        return Arenas.SuperArena.Tick(self)

 
       
Arenas.register(BoxArena)
